﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Project.master" AutoEventWireup="true"
    CodeBehind="ProjectDemographicData.aspx.cs" Inherits="GUI.Pages.ProjectDemographicData" %>

<%@ Register Src="~/Controls/ProjectNavTest.ascx" TagName="ProjectNavTest" TagPrefix="uc" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:ProjectNavTest ID="ProjectNavTest" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
<div class="row">
    <div class="col-md-12 col-sm-12">
    <div class="portlet light bordered light-blue">
            <div class="portlet-title">
                <div class="caption">
                    <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal7" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_DemographicData %>" /> </span>
                </div>
            </div>
            <div class="portlet-body form">
                 <div class="form-body">
                     <div class="row">
                     <asp:HiddenField runat="server" ID="txtProjectDemographicDataId" />
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label"><asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Demographic_UsersCount %>" /></label>
                            <div class="form-group">
                                 <telerik:RadNumericTextBox Width="100%" Skin="Bootstrap" runat="server" ValidationGroup="Validacija" ID="txtNumberOfUsers" />
                     
                            </div> 
                            <span class="help-block"> <asp:RequiredFieldValidator ID="txtNumberOfUsersRequired" ValidationGroup="Validacija" runat="server" Display="Dynamic"
                            CssClass="vError" SetFocusOnError="true" ControlToValidate="txtNumberOfUsers"
                            ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label"><asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Demographic_ProjectUser %>" /></label>
                            <div class="input-group">
                                <asp:DropDownList runat="server" ValidationGroup="Validacija" CssClass="form-control" ID="ddlProjectUser" />
                                <span class="input-group-btn">
                                    <asp:LinkButton ID="btnAddUser" OnClick="BtnAddClick" CssClass="btn blue" runat="server">
                                        <i class="fa fa-plus"></i>
                                    </asp:LinkButton>	
                                </span>
                            </div> 
                            <span class="help-block"><asp:RequiredFieldValidator ID="ddlProjectUserRequired" ValidationGroup="Validacija" runat="server" Display="Dynamic"
                            CssClass="vError" SetFocusOnError="true" ControlToValidate="ddlProjectUser" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                            ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span>
                        </div>
                    </div>
                     <div class="col-md-3">
                         <div class="form-group">
                            <label></label>
                            <div class="mt-checkbox-list">
                                <label class="mt-checkbox"><asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, Demographic_Gender %>" />
                                    <asp:CheckBox runat="server" ID="chkGenderPresence" OnCheckedChanged="chkGenderPresenceCheckedChanged" AutoPostBack="True" />
                                    <span></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3">
                         <div class="form-group">
                            <label class="control-label"><asp:Literal ID="Literal6" runat="server" Text="<%$ Resources:ProjectManagementUI, Demographic_Mens %>" /></label>
                            <div class="form-group">
                                 <telerik:RadNumericTextBox Skin="Bootstrap" Width="100%" Type="Number" runat="server" ID="txtMen" />
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                         <div class="form-group">
                            <label class="control-label"><asp:Literal ID="Literal8" runat="server" Text="<%$ Resources:ProjectManagementUI, Demographic_Womens %>" /></label>
                            <div class="form-group">
                                <telerik:RadNumericTextBox Skin="Bootstrap" Width="100%" Type="Number" runat="server" ID="txtWomen" />
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                         <div class="form-group">
                            <label class="control-label"><asp:Literal ID="Literal9" runat="server" Text="<%$ Resources:ProjectManagementUI, Demographic_Childrens %>" /></label>
                            <div class="form-group">
                                <telerik:RadNumericTextBox Skin="Bootstrap" Width="100%" Type="Number" runat="server" ID="txtChildren" />
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                         <div class="form-group">
                            <label class="control-label"><asp:Literal ID="Literal10" runat="server" Text="<%$ Resources:ProjectManagementUI, Demographic_Unknown %>" /></label>
                            <div class="form-group">
                                 <telerik:RadNumericTextBox Skin="Bootstrap" Width="100%" Type="Number" runat="server" ID="txtUnknown" />
                            </div>
                        </div>
                    </div>
                </div>

                     <div class="row">
                    <div class="col-md-12">
                         <div class="form-group">
                            <label class="control-label"><asp:Literal ID="Literal11" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Description %>" /></label>
                            <div class="form-group">
                                <asp:TextBox TextMode="MultiLine" CssClass="form-control" Rows="3" runat="server" ID="txtDescription" />
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-actions right">
                   <asp:Button ID="btnSave" ValidationGroup="Validacija" OnClick="BtnSaveClick" CssClass="btn red" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                            runat="server" />
                    <asp:Button ID="btnNew" OnClick="BtnNewClick" CssClass="btn blue" Text="<%$ Resources:ProjectManagementUI, Common_New %>" runat="server" />
                </div>

                <telerik:RadGrid ID="grdProjectDemographicData" runat="server" OnItemCommand="grdProjectDemographicDataItemCommand" CssClass="kendo-table" Skin="Bootstrap">
                        <MasterTableView ShowHeadersWhenNoRecords="true" NoMasterRecordsText="<%$ Resources:ProjectManagementUI, Common_NoData %>" CssClass="table table-striped table-hover"
                            ShowFooter="False" AutoGenerateColumns="False" AllowCustomSorting="false" DataKeyNames="Id">
                            <Columns>
                                <telerik:GridBoundColumn UniqueName="IdColumn" HeaderText="Id" DataField="Id" />
                                <telerik:GridBoundColumn UniqueName="NumberOfUsersColumn" SortExpression="NumberOfUsers"
                                    HeaderText="<%$ Resources:ProjectManagementUI, Demographic_UsersCount %>" DataField="NumberOfUsers" />
                                <telerik:GridBoundColumn UniqueName="ProjectUserColumn" SortExpression="ProjectUser.Name"
                                    HeaderText="<%$ Resources:ProjectManagementUI, Demographic_ProjectUser %>" DataField="ProjectUser.NameLocalized" />
                                <telerik:GridBoundColumn UniqueName="GenderPresenceColumn" SortExpression="GenderPresenceDisplay"
                                    HeaderText="<%$ Resources:ProjectManagementUI, Demographic_Gender %>" DataField="GenderPresenceDisplay" />
                                <telerik:GridBoundColumn UniqueName="MenDisplayValueColumn" SortExpression="MenDisplayValue"
                                    HeaderText="<%$ Resources:ProjectManagementUI, Demographic_Mens %>" DataField="MenDisplayValue" />
                                <telerik:GridBoundColumn UniqueName="WomenDisplayValueColumn" SortExpression="WomenDisplayValue"
                                    HeaderText="<%$ Resources:ProjectManagementUI, Demographic_Womens %>" DataField="WomenDisplayValue" />
                                <telerik:GridBoundColumn UniqueName="ChildrenDisplayValueColumn" SortExpression="ChildrenDisplayValue"
                                    HeaderText="<%$ Resources:ProjectManagementUI, Demographic_Childrens %>" DataField="ChildrenDisplayValue" />
                                <telerik:GridBoundColumn UniqueName="UnknownDisplayValueColumn" SortExpression="UnknownDisplayValue"
                                    HeaderText="<%$ Resources:ProjectManagementUI, Demographic_Unknown %>" DataField="UnknownDisplayValue" />
                                 
                                <telerik:GridButtonColumn CommandName="Select" UniqueName="SelectColumn" HeaderStyle-Width="5%"
                                    ButtonCssClass="btn btn-sm blue" HeaderText="" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Choose %>" />

                                <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderStyle-Width="5%"
                                    ButtonCssClass="btn btn-sm red" HeaderText="" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ConfirmText="<%$ Resources:ProjectManagementUI, Common_DeletingConfirm %>"
                                    ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>" />
                            </Columns>
                        </MasterTableView>
                    </telerik:RadGrid>
                 </div>
            </div>
        </div>
    </div>
</div>
</asp:Content>
